<?php
/*--------------------------------------------------------------------
 gm_prepare_string.inc.php 2025-12-30
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2025 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

function gm_magic_check($string){
    if(preg_match('/(^"|[^\\\\]{1}")/', $string) == 1) return false;
    if(preg_match('/(^\'|[^\\\\]{1}\')/', $string) == 1) return false;
    else return true;   
}


function gm_prepare_string($string, $strip = false)
{
    $string = (string)$string;
    
    if ($strip) {
        $string = stripslashes($string);
    }
    
    if (isset($GLOBALS["___mysqli_ston"]) && is_object($GLOBALS["___mysqli_ston"])) {
        return mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $string);
    }
    
    return addslashes($string);
}